﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Pravokotnik_IComparable
{
    class Pravokotnik : IComparable<Pravokotnik>
    {
        private int stA;
        private int stB;
        // Lastnosti
        public int A
        {
            get { return this.stA; }
            set { if (vRedu(value)) this.stA = value; }
        }
        public int B
        {
            get { return this.stB; }
            set { if (vRedu(value)) this.stB = value; }
        }

        // pomožna metoda 
        private bool vRedu(int x)
        {
            return x > 0;
        }

        public Pravokotnik()
        {
            // privzeti pravokotnik je 1 x 1
            this.A = 1;
            this.B = 1;
        }

        public Pravokotnik(int x, int y) : this() // klic privzetega konstruktorja
        {
            // pravokotnik x X y
            // če je x ali y negativen ali 0, ga postavimo na 1
            this.A = x; // izvede se ustrezna metoda set, ki preveri podatke!
            this.B = y;
        }

        public int Obseg
        {   // obseg pravokotnika
            get { return 2 * (this.A + this.B); }
        }
        public int Ploscina
        {    // ploščina pravokotnika
            get { return (this.A * this.B); }
        }

        public override string ToString()
        {
            return this.A + " x " + this.B;
        }

        public int CompareTo(Pravokotnik drugi)
        {
            if ((this.A == drugi.A) && (this.B == drugi.B)) return 0;
            if (this.A < drugi.A) return -1;
            if (this.A > drugi.A) return 1;
            // this.A == drugi.A, this.B != drugi.B
            if (this.B < drugi.B) return -1;
            return 1;
        }

    }
}
